<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class CitySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $cities = [
            [
                'state_id' => 1,
                'name' => 'Faizabad',
                'status' => true,
            ],
            [
                'state_id' => 1,
                'name' => 'Jurm',
                'status' => true,
            ],
            [
                'state_id' => 1,
                'name' => 'Khandud',
                'status' => true,
            ],
            [
                'state_id' => 1,
                'name' => 'Ragh',
                'status' => true,
            ],
            [
                'state_id' => 1,
                'name' => 'Shahr-e Buzurg',
                'status' => true,
            ],
            [
                'state_id' => 1,
                'name' => 'Shighnan',
                'status' => true,
            ],
            [
                'state_id' => 1,
                'name' => 'Tal',
                'status' => true,
            ],
            [
                'state_id' => 1,
                'name' => 'Tishkan',
                'status' => true,
            ],
            [
                'state_id' => 2,
                'name' => 'Bala Murghab',
                'status' => true,
            ],
            [
                'state_id' => 2,
                'name' => 'Ghormach',
                'status' => true,
            ],
            [
                'state_id' => 2,
                'name' => 'Jawand',
                'status' => true,
            ],
            [
                'state_id' => 2,
                'name' => 'Muqur',
                'status' => true,
            ],
            [
                'state_id' => 2,
                'name' => 'Qadis',
                'status' => true,
            ],
            [
                'state_id' => 2,
                'name' => 'Qala i Naw',
                'status' => true,
            ],
            [
                'state_id' => 2,
                'name' => 'Sang Atesh',
                'status' => true,
            ],
            [
                'state_id' => 2,
                'name' => 'Shahrak',
                'status' => true,
            ],
            [
                'state_id' => 14,
                'name' => 'Gazipur',
                'status' => true,
            ],
            [
                'state_id' => 14,
                'name' => 'Badda',
                'status' => true,
            ],
            [
                'state_id' => 14,
                'name' => 'Dhaka',
                'status' => true,
            ],
            [
                'state_id' => 14,
                'name' => 'Khilgaon',
                'status' => true,
            ],
            [
                'state_id' => 14,
                'name' => 'Mirpur',
                'status' => true,
            ],
            [
                'state_id' => 14,
                'name' => 'Mohammadpur',
                'status' => true,
            ],
            [
                'state_id' => 14,
                'name' => 'Motijheel',
                'status' => true,
            ],
            [
                'state_id' => 14,
                'name' => 'Pallabi',
                'status' => true,
            ],
            [
                'state_id' => 14,
                'name' => 'Ramna',
                'status' => true,
            ],
            [
                'state_id' => 14,
                'name' => 'Savar',
                'status' => true,
            ],
            [
                'state_id' => 14,
                'name' => 'Tejgaon',
                'status' => true,
            ],
            [
                'state_id' => 14,
                'name' => 'Uttara',
                'status' => true,
            ],
            [
                'state_id' => 14,
                'name' => 'Wari',
                'status' => true,
            ],
            [
                'state_id' => 16,
                'name' => 'Bagerhat',
                'status' => true,
            ],
            [
                'state_id' => 15,
                'name' => 'Bandarban',
                'status' => true,
            ],
            [
                'state_id' => 16,
                'name' => 'Barguna',
                'status' => true,
            ],
            [
                'state_id' => 16,
                'name' => 'Barisal',
                'status' => true,
            ],
            [
                'state_id' => 16,
                'name' => 'Bhola',
                'status' => true,
            ],
            [
                'state_id' => 16,
                'name' => 'Jhalokati',
                'status' => true,
            ],
            [
                'state_id' => 16,
                'name' => 'Patuakhali',
                'status' => true,
            ],
            [
                'state_id' => 16,
                'name' => 'Pirojpur',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Bogura',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Joypurhat',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Naogaon',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Natore',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Nawabganj',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Pabna',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Rajshahi',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Sirajganj',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Dinajpur',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Gaibandha',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Kurigram',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Lalmonirhat',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Nilphamari',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Panchagarh',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Rangpur',
                'status' => true,
            ],
            [
                'state_id' => 17,
                'name' => 'Thakurgaon',
                'status' => true,
            ],
            [
                'state_id' => 19,
                'name' => 'Habiganj',
                'status' => true,
            ],
        ];

        foreach ($cities as $city) {
            \App\Models\City::updateOrCreate([
                'name' => $city['name'],
                'state_id' => $city['state_id'],
            ], $city);
        }
    }
}
